<?php

namespace app\model;

use think\Model;
use think\Db;

class AppointWatchShop extends Model
{
    // 设置当前模型对应的完整数据表名称
    protected $table = 'u_appoint_watch_shop';
    protected $db;

    function __construct()
    {
        $this->db = Db($this->table);
    }

    /** 保存预约看铺信息
     * @param $arr
     * @return array
     */
    public function insertAppointWatchShop($arr)
    {
        Db::startTrans();
        try {
            $id = $this->save($arr);
            Db::commit();
            return [ "code" => "200", "msg" => $id ];
        } catch (\Exception $e) {
            Db::rollback();
        }
        return [ "code" => "101", "msg" => "数据保存异常，rollback" ];
    }

    /**
     * 预约看铺列表
     *
     * @param int $pageNo
     * @param int $pageSize
     * @param string $order_
     * @param $field
     * @param $params
     * @return mixed
     */
    public function getAppointWatchShopList($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field, $params)
    {
        return  $this
            ->field($field)
            ->where($params)
            ->order($order_)
            ->limit($pageSize)
            ->page($pageNo)
            ->select();
    }

    /**
     * 预约看铺总数
     *
     * @param $params
     * @return int|string
     */
    public function getAppointWatchShopListTotal($params)
    {
        return  $this->where($params)->count();
    }
}
