<?php
/**
 * Created by PhpStorm.
 * User: fuju
 * Date: 2017/12/20
 * Time: 18:01
 */

namespace app\index\controller;


use app\index\extend\Basic;
use app\model\AdminModel;
use app\model\FollowUp;
use app\model\SubletModel;
use app\model\Users;
use think\Session;


class Transfer extends Basic
{
    /**
     * 转铺列表
     *
     * @return \think\response\View
     */
    public function index() {
        return view('transfer/index');
    }

    /**
     * 获取转铺列表
     *
     * @return \think\Response
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getList() {
        $data['status'] = 200;
        $data['msg']    = '';

        $params = $this->request->param();
        $pageNo   = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 15 : $params['pageSize'];

        $where = array();

        if (!empty($params['start_date'])) {
            $where['create_time'] = ['> time', $params['start_date']];
        }

        if (!empty($params['end_date'])) {
            $where['create_time'] = ['< time', $params['end_date']];
        }

        if (!empty($params['name'])) {
            $where['appellation'] = ['like', $params['name'].'%'];
        }

        if (!empty($params['phone'])) {
            $where['tel'] = ['like', $params['phone'].'%'];
        }

        if (!empty($params['shop_name'])) {
            $where['shop_name'] = ['like', $params['shop_name'].'%'];
        }

        $sublet = new SubletModel();

        $fields = 'id,shop_name,manage_type,address_detail,province,city,district,expected_rent,appellation,tel,create_time,status';

        $data['list'] = $sublet->getSublet($pageNo, $pageSize, 'id desc', $fields, $where);
        $data['total'] = $sublet->getSubletTotal($where);
        return $this->response($data['status'], $data['msg'], $data);
    }


    /**
     * 设置转为商铺
     *
     * @return array
     */
    public function putAway() {
        $data['status'] = 200;
        $data['msg']    = '';

        $params = $this->request->param();
        try {
            $sublet = new SubletModel();
            $sublet->update([
                'id' => $params['id'],
                'status' => $params['status']
            ]);

            return [ "code" => "200", "msg" => '操作成功', 'data'=>['status'=>$params['status']]];
        } catch (\Exception $e) {
            return [ "code" => "101", "msg" => "操作失败", 'data'=>''];
        }
    }

    /**
     * 添加跟进信息
     *
     * @return \think\Response
     */
    public function addFollow() {
        $data['status'] = 200;
        $data['msg']    = '';

        $params = $this->request->param();

        $follow = new FollowUp();
        $follow->save([
            'content'  => $params['content'],
            'sublet_id' => $params['id'],
            'admin_id' => Session::get('userId'),
            'create_time' => date('Y-m-d H:i:s'),
            'type' => $params['type']
        ]);

        if (!$follow->id) {
            $data['status'] = 101;
            $data['msg']    = '操作失败';
        }

        return $this->response($data['status'],$data['msg'],['id'=> $follow->id]);
    }

    /**
     * 获得跟进信息
     *
     * @return \think\Response
     * @throws \think\exception\DbException
     */
    public function FollowList() {
        $data['status'] = 200;
        $data['msg']    = '';

        $params = $this->request->param();

        if ($params['id']) {
            $follow = new FollowUp();
            $users = new AdminModel();
            $list = $follow->where([
                'sublet_id' => $params['id'],
                'type'      => $params['type']
            ])->select();
            foreach ($list as $k=>$v) {
                $data['data'][$k] = $v;
                $data['data'][$k]['admin_name'] = $users->field('name')->find()['name'];
            }

        } else {
            $data['status'] = 101;
            $data['msg']    = 'id is null';
        }

        return $this->response($data['status'],$data['msg'],$data['data']);
    }

}