<?php

namespace app\model;

use think\Model;

class Evaluate extends Model
{
    // 设置当前模型对应的完整数据表名称
    protected $table = 'u_evaluate';

    /**
     * 获得评价列表
     * 
     * @param type $pageNo
     * @param type $pageSize
     * @param type $order_
     * @param type $field
     * @param type $params
     * @param type $agent_id //获得经纪人的评价
     * @return type
     */
    public function getEvaluate($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field, $params, $agent_id = '') {
    
        if ($agent_id) {
            $result = $this->field($field)->alias('a')
                    ->join('u_users b','a.user_id = b.id','left')
                    ->where('agents_id',$agent_id)
                    ->where('is_show',0)
                    ->order($order_)
                    ->limit($pageSize)
                    ->page($pageNo)
                    ->select();
      
        } else {
            $result = $this->field($field)->alias('a')
                    ->join('u_users b', 'a.user_id = b.id', 'left')
                    ->where('is_show', 0)
                    ->order($order_)
                    ->limit($pageSize)
                    ->page($pageNo)
                    ->select();
        }

        $sign    = new EvaluateSign();
        $applies = new Applies();
        $house   = new HouseInfos();

        foreach ($result as $k=>$v) {
            $data[$k]   = $v->getData();
            $data[$k]['user_pic'] = CURRENT_URL.'/static/head_portrait/'.$data[$k]['user_pic'];
            if ($v['evaluate_sign']) {
                 $data[$k]['evaluate_sign'] = $sign->field('sign_name,point_obj')
                         ->where('id', 'in', $v['evaluate_sign'])
                         ->where('is_del',0)
                         ->select();
            }

            //看铺时间
            $applies_time = $applies->field('receptiontime,created')
                    ->where('phpone',$v['user_phone'])
                    ->find();
            
            $house_address = $house->field('address')->where('id',$v['house_id'])->find(); //商铺地址

            $data[$k]['houserAddress'] = $house_address ? $house_address : '';
            $data[$k]['receptiontime'] = $applies_time['receptiontime'] ? $applies_time['receptiontime']:'';
            $data[$k]['created'] = $applies_time['created'] ? $applies_time['created']:'';

        }
                
        return $data;
    }

    /**
     * 获取商铺是否评价
     * @param int $source
     * @param $recordId
     * @param $userId
     * @return false|\PDOStatement|string|\think\Collection
     */
    public function getIsEvaluate($source ,$recordId , $userId){
        $params["source"] = $source ;
        $params["record_id"] = $recordId;
        $params["user_id"] = $userId;
        return $this->field("id")
            ->where($params)
            ->select();

    }
}
