<?php

namespace app\api\controller;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2017/12/12
 * Time : 10:39
 * Intro: 委托转铺
 */
use app\api\extend\Basic;
use app\model\SubletModel;
use think\Request;

class Sublet extends Basic
{
    protected $subletMode;

    public function __construct($request = null)
    {
        parent::__construct($request);
        $this->subletMode = new SubletModel();
    }

    public function addSublet()
    {
        $params = $this->params;
     /*        $params = array(
                 "user_id" => 47,
                 "manage_type" => 美食,
                 "address_detail" => "泗泾",
                 "province" => "上海",
                 "city" => "长沙市",
                 "district" => "芙蓉区",
                 "expected_rent" => 2000,
                 "appellation" => "zhangsan",
                 "tel" => 13817616162,
                 "AuthToken" => 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJkYXRhIjp7ImlkIjo0NywidXNlck5pY2siOm51bGwsInBob25lIjoiMTgyMDU2MjUwMjAifSwidGltZVN0YW1wXyI6MTUxMzU3MzMwMH0.-_tpSDeucA6_V8glS1hfoNBpZU8lRk6J8On3-_Rdf_I',
             );*/


        if (!isset($params["manage_type"])) {
            $this->response("101", "经营业态不能为空");
        }

        if (!isset($params["address_detail"])) {
            $this->response("101", "详细地址不能为空");
        }

        /*    if (!isset($params["province"]) || !isset($params["province_code"]) || !isset($params["city"]) ||
                !isset($params["city_code"]) || !isset($params["district"]) || !isset($params["district_code"])) {
                $this->response("101", "省市区不能为空");
            }*/

        if (!isset($params["province"]) || !isset($params["city"]) || !isset($params["district"])) {
            $this->response("101", "省市区不能为空");
        }

        if (!isset($params["expected_rent"])) {
            $this->response("101", "期望租金不能为空");
        }

        if (!isset($params["appellation"])) {
            $this->response("101", "称呼不能为空");
        }

        if (!isset($params["tel"]) || !preg_match('/1[345678]\d{9}/', $params["tel"])) {
            $this->response("101", "手机号检验错误");
        }
        $params["create_time"] = date("Y-m-d H:i:s", time());
        $params["update_time"] = date("Y-m-d H:i:s", time());

        unset($params["AuthToken"]);
        $result = $this->subletMode->addSublet($params);
        if ($result["code"] == 200) {
            return $this->response("200", "数据保存成功", $result["msg"]);
        }

        return $this->response("101", "数据保存失败");
    }

}
