<?php

namespace app\model;

use think\Model;

class AttentionModel extends Model
{
    // 设置当前模型对应的完整数据表名称
    protected $table = 'u_attention';

    public function __construct()
    {

    }

    /**
     * 新增或取消我关注的店铺
     * @param $params
     * @return array
     */
    public function addOrUpdateAttentionShop($params){
        $arr = array();

        if (isset($params['user_id'])) {
            $arr["user_id"] = $params['user_id'];
        }
        if (isset($params['house_id'])) {
            $arr["house_id"] = $params['house_id'];
        }
        if (isset($params['is_del'])) {
            $arr["is_del"] = $params['is_del'];
        }


        if (isset($params['id'])) {
            $result = $this
                ->where("id=" . $params['id'])
                ->select();
            if (count($result) > 0) {
                $arr["id"] = $params["id"];
            } else {
                return [ "code" => "101", "msg" => "数据不存在" ];
            }
        } else {
            $arr["create_time"] = time();
        }
        Db::startTrans();
        try {
            $id = $this->save($arr);
            Db::commit();
            return [ "code" => "200", "msg" => $id ];
        } catch (\Exception $e) {
            Db::rollback();
            return [ "code" => "101", "msg" => "失败，数据异常" ];
        }
    }

    /**
     * 获取我关注的商品列表
     * @param int $pageNo
     * @param int $pageSize
     * @param string $order_
     * @param $field
     * @param $param
     * @return false|\PDOStatement|string|\think\Collection
     */
    public function myAttentionList($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field, $param){
        $params["a.user_id"] = $param["user_id"];
        $params["b.room_num_left"] = array("<>",0); //剩余数为0 的商品不显示
         return $this->field($field)
            ->alias("a")
            ->join('houseinfos b','a.house_id = b.id','LEFT')
            ->where($params)
            ->order($order_)
            ->limit($pageSize)
            ->page($pageNo)
            ->select();
    }
}
