<?php

namespace app\model;

use think\Model;
use think\Db;

class Agents extends Model
{
    /**
     * 查询经纪人
     * 
     * @param type $pageNo
     * @param type $pageSize
     * @param type $order_
     * @param type $field
     * @param type $params
     * @param type $house_id 查询该街铺和商铺的经纪人
     * @return type
     */
    public function getUser($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field, $params, $house_id = '') {
        if ($house_id == '') {
            $data = $this->field($field)
                    ->where($params)
                    ->where('level=2 or level=5')
                    ->order($order_)
                    ->limit($pageSize)
                    ->page($pageNo)
                    ->select();
        } else {
            
            $agent_data = $this->field($field)
                    ->where('find_in_set('.$house_id.', house_ids) or find_in_set('.$house_id.', house_ids2)')
                    ->where($params)
                    ->where('level=2 or level=5')
                    ->order($order_)
                    ->limit($pageSize)
                    ->page($pageNo)
                    ->select();
            $evaluate = new Evaluate();            
           
            foreach ($agent_data as $k=>$v) {
                $data[$k]['id'] = $v->id;
                $data[$k]['realname'] = $v->realname;
                $data[$k]['phone']    = $v->phone;
                $data[$k]['evaluate'] = $evaluate->where('agents_id',$v->id)->count();
                $data[$k]['evaluate_grade'] = $evaluate->where('agents_id',$v->id)->avg('evaluate_grade');
                $data[$k]['label']    = '';
            }
        }
        
        return $data; 
    }
    
    /**
     * 经纪人详情
     * 
     * @param type $id
     * @return boolean
     */
    public function agentsDetail($id) {
        if ($id) {
            $result = $this->field('id,realname,created,sub_shopname,head_portrait')->where('id',$id)->find();
           $result['head_portrait'] = 'user_header/'.$result['head_portrait'];
           $result['evaluate_grade'] = Db::table('');
        } else {
            $data = false;
        }
        
        return $result;
    }
}
