<?php

namespace app\api\controller;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2017/12/6
 * Time : 15:12
 * Intro: 获取商铺list
 */
use app\api\extend\Basic;
use app\model\HouseImgs;
use app\model\HouseInfos;
use app\model\Labels;

class Shop extends Basic
{
    protected $db;
    protected $dbImg;
    protected $labels;

    function __construct($request = null)
    {
        parent::__construct($request);
        $this->db = new HouseInfos();
        $this->dbImg = new HouseImgs();
        $this->labels = new Labels();
    }

    /**
     * @return \think\Response
     */
    public function getShopList()
    {

        /*   $params = array(
               "site_area" => 2, //来源 1首页  2搜索
               "title" => "尚美",
               "carefully_chosen" => 0,
                "disc" => "黄浦区",
               "yetai" => "休闲娱乐",
               "area_start" => 45,//面积起始范围 room_area2
               "area_end" => 65,//面积结束范围
               "money_start" => 1000,//租金 price2
               "money_end" => 10000,//租金
               "shangpu_tags" => "临近地铁,",
               "pageNo" => "1",
               "pageSize" => 15
           );*/
        $params = $this->params;
        $field = "id,agent_id,title,address,city,disc,disccircles,sales,yetai,room_area,room_area2,shangpu_type,is_test,
                  room_num_left,shangpu_tags,carefully_chosen,price";

        $conditions = [];
        if (empty($params['site_area'])) {
            return $this->response("101", "请求来源不能为空");
        }

        $pageNo = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 15 : $params['pageSize'];

        if (isset($params['title'])) {
            $conditions['title'] = array( "like", "%" . trim($params['title']) . "%" );
        }
        $order_ = "";
        switch ($params['site_area']) {
            case 1:
                if (isset($params['carefully_chosen']) && $params['carefully_chosen'] == 0) {
                    $conditions['carefully_chosen'] = array( 'eq', $params['carefully_chosen'] );
                    $order_ = "rate1 desc";
                }
                break;
            case 2:
                if (isset($params['disc'])) { //区域
                    $conditions['disc'] = array( 'eq', trim($params['disc']) );
                }

                if (isset($params['yetai'])) { //业态
                    $conditions['yetai'] = array( 'like', "%" . trim($params['yetai']) . "%" );
                }

                //面积 room_area最小面积  room_area2最大面积 参考老版本
                if (isset($params['area_start']) && isset($params['area_end'])) {
                    $conditions['room_area'] = array( 'between', array( $params['area_start'], $params['area_end'] ) );
                    $conditions['room_area2'] = array( 'between', array( $params['area_start'], $params['area_end'] ) );
                } else if (isset($params['area_start']) && !isset($params['area_end'])) { //100米以上不用传结束面积
                    $conditions['room_area'] = array( 'egt', $params['area_start'] );
                    $conditions['room_area2'] = array( 'egt', $params['area_start'] );
                }

                if (isset($params['money_start']) && isset($params['money_end'])) { //面积
                    $conditions['price'] = array( 'between', array( $params['money_start'], $params['money_end'] ) );
                } else if (isset($params['money_start']) && !isset($params['money_end'])) { //100米以上不用传结束面积
                    $conditions['price'] = array( 'egt', $params['money_start'] );
                }

                if (isset($params['shangpu_tags'])) { //商铺标签
                    $shangpuTagsArr = array_filter(explode(',', $params['shangpu_tags']));
                    if (count($shangpuTagsArr) == 1) {
                        $conditions['shangpu_tags'] = array( 'like', "%" . trim($shangpuTagsArr[0]) . "%" );
                    } else {
                        foreach ($shangpuTagsArr as $key => $val) {
                            $conditions['shangpu_tags'][] = array( 'like', "%" . trim($val) . "%" );
                        }
                    }
                }
                $order_ = "id desc";
                break;
            default:
                $this->response("101", "请求数据异常");
        }
        if (!empty($conditions)) {
            //todo 测试数据？
            $conditions['id'] = array( '<>', 16 );
            //todo sales下架字段并没用处 根据room_num_left剩余铺数来判断 为0 表示下架
            $conditions['room_num_left'] = array( '<>', 0 );
        }

        $result = $this->db->getHouseInfoList($pageNo, $pageSize, $order_, $field, $conditions);

        //获取图片信息
        foreach ($result as $key => $val) {
            $result[$key]["api_path"] = IMG_PATH;
            $param["house_id"] = $val["id"];
            $param["imgtype"] = 1; //默认主图
            $result[$key]["images"] = $this->dbImg->getHouseImages($param, 1);
        }

        if (empty($result)) {
            return $this->response("200", "此条件没有找到数据");
        }

        return $this->response("200", 'request success', $result);
    }

    /**
     * 楼盘详情
     * @return \think\Response
     */
    public function getShopDetail()
    {
        $params = $this->params;
        $field = "id,management_fee,title,address,city,disc,disccircles,sales,yetai,room_area2,shangpu_type,is_test,
                  room_num_left,shangpu_tags,carefully_chosen,price,dish,file_path";

        $conditions = [];
        if (empty($params['id'])) {
            return $this->response("101", "详情id不能为空");
        }

        $conditions['id'] = array( "eq", $params["id"] );

        $result = $this->db->getHouseDetail($field, $conditions);
        if ($result[0]['room_num_left'] == 0) {
            return $this->response("101", '此楼盘已下架');
        }
        return $this->response("200", 'request success', $result);
    }


    /**
     * 搜索页搜索条件
     * @return \think\Response
     */
    public function filtrateCondition()
    {
        $field = "city,disc";
        $param['id'] = array( '<>', 16 );
        $param['room_num_left'] = array( '<>', 0 );
        $group_ = "disc";
        $cityList = $this->db->getCityList($field, $param, $group_);

        foreach ($cityList as $k => $v) {
            $cityArr[] = $v["city"];
        }
        $cityArr = array_unique($cityArr);
        $i = 0;
        $result["area"][$i]["city"] = "全部";
        $result["area"][$i]["disc"][] = "全部";
        foreach ($cityArr as $key => $val) {
            $i++;
            $result["area"][$i]["city"] = $val;
            $result["area"][$i]["disc"][] = "全" . $val;
            foreach ($cityList as $k => $v) {
                if ($val == $v["city"]) {
                    $result["area"][$i]["disc"][] = $v["disc"];
                }
            }
        }
        $result['yetai'] = array( '全部', '餐饮美食', '零售', '休闲娱乐', '其他' );

        //租金租金(0:租金-大于三万; 1:租金一万到三万之间; 2:租金-小于一万)
        $result['money'] = array( array( 'id' => '-1', 'value' => '全部' ), array( 'id' => '0', 'value' => '3万以上' ),
            array( 'id' => '1', 'value' => '1万-3万' ), array( 'id' => '2', 'value' => '1万以下' ) );

        //面积
        $result['acreage'] = array( array( 'id' => '-1', 'value' => '全部' ), array( 'id' => '0', 'value' => '30m²以内' ),
            array( 'id' => '1', 'value' => '30-60m²' ), array( 'id' => '2', 'value' => '60-100m²' ), array( 'id' => '3', 'value' => '100m²以上' ) );

        $result['more'][] = "更多";
        $labelsResult = $this->labels->getLabels();
        if (count($labelsResult) > 0) {
            foreach ($labelsResult as $labelsKey => $labelsVal) {
                if ($labelsVal['name']) {
                    $result['more'][] = $labelsVal['name'];

                }
            }
        }

        return $this->response("200", "request success", $result);
    }
}