$(function() {
	$(document.body).show();
	var _doc = $(document);
	var _appToken = getUrlParam('token');
	var _agentId = getUrlParam('agentId');
	
	if(_appToken !== null) {
		_doc.on('click', '.ps-back', function(e) {
			e.preventDefault();
			e.stopPropagation();
			Compatible({
				paraIos: {
					'route': "aabb",
					'url': 'back'
				},
				fnAndroid: function() {
					window.android.onBackPressed();
				},
				fn: function() {
					console.warn('error');
				}
			});
		});
		h5Page(_appToken, function(data) {
			loadMain();
		});
	} else {
		loadMain();
	};
	
	function loadMain() {
		var _token = localStorage.getItem('token');
		var loadItem = $('#loading_pic');
		$.ajax({
			type: 'get',
			url: ServerHost + '/api/brokerDetail',
			timeout: 30000,
			dataType: 'json',
			data: {
				'agent_id': _agentId,
				'AuthToken': _token
			},
			beforeSend: function() {},
			success: function(data) {
				if(typeof data === 'object') {
					if(data['code'] == 200) {
						$('#name_jingjiren').html(data['data']['realname']);
						$('#time_ruzhi').html(data['data']['created']);
						$('#name_store').html(data['data']['sub_shopname']);
						$('.portrait-area>img').attr('src', data['data']['head_portrait']);
						var _fenNum = parseInt(Number(data['data']['evaluate_grade']));
						var _pingNum = Number(data['data']['evaluate_num']) > 99 ? '99+' : Number(data['data']['evaluate_num']);
						$('#pingjia_fen').html(_fenNum);
						$('.pingfen-area-large').html(dealStar(_fenNum));
						$('#pingjia_shu').html(_pingNum).attr('data-num',Number(data['data']['evaluate_num']));
						$('#chengjiao_lishi').html(data['data']['JournalAccounts']);
						$('#daikan_30').html(data['data']['watch_shop']);
						loadList(_fenNum, _pingNum);
					} else {
						layerTipsX(data['msg']);
					};
				} else {
					layerTipsX('数据错误');
				};
			},
			error: function(XMLHttpRequest, textStatus, errorThrown) {
				layerTipsX('error');
			},
			complete: function(xhr, textStatus) {
				if(textStatus === 'timeout') {
					layerTipsX('请求超时');
				};
			}
		});

		function dealStar(_fen) {
			var _htmlTemp = '';
			for(var i = 1; i < 6; i++) {
				if(i < _fen + 0.5) {
					_htmlTemp += '<small class="small-active"></small>';
				} else if(i == _fen + 0.5) {
					_htmlTemp += '<small class="small-active-guodu"></small>';
				} else {
					_htmlTemp += '<small></small>';
				}
			};
			return _htmlTemp;
		};

		function dealStarText(_fen) {
			if(_fen >= 4) {
				return '非常推荐';
			} else if(_fen >= 3) {
				return '很好';
			} else if(_fen >= 2) {
				return '一般';
			} else if(_fen >= 1) {
				return '很差';
			} else {
				return '非常差';
			};
		};

		function dealScale(obj) {
			if(obj['shangpu_type'] == '0') {
				return Number(obj['room_area']) + '-' + Number(obj['room_area2']) + 'm²';
			} else {
				return Number(obj['room_area']) + 'm²';
			};
		};
		
		function dealPicUrl(_img, _morenImg){
			if(_img){
				var _arrTemp = _img.split('/');
				if(_arrTemp[_arrTemp.length-1] == ''){
					return _morenImg;
				}else{
					return location.protocol +'//'+ _img;
				}
			}else{
				return _morenImg;
			};
		};
		
		function dealTags(arr){
			if(arr.length > 0&&arr[0]!=''){
				if(arr.length<3){
					var _htmlTemp = '';
					for(var i = 0;i<arr.length;i++){
						_htmlTemp += '<span>' +arr[i] +'</span>';
					};
					return _htmlTemp;
				}else{
					return '<span>'+arr[0]+'</span><span>'+arr[1]+'</span><span>'+arr[2]+'</span>';
				};
			}else{
				return '';
			}
		};
		
		function dealTimeKf(str){
			if(str === '' || str === null || str === undefined ){
				return '';
			}else{
				return str.split('-')[0] + '-' + str.split('-')[1];
			}
		};

		function loadList(_fenNum, _pingNum){
			$.ajax({
				type: 'get',
				url: ServerHost + '/api/commentAndDeal',
				timeout: 30000,
				dataType: 'json',
				data: {
					'agent_id': _agentId,
					'type': 0,
					'pageNo': 1,
					'pageSize': 3,
					'AuthToken': _token
				},
				beforeSend: function() {
					loadItem.show();
				},
				success: function(data) {
					if(typeof data === 'object') {
						if(data['code'] == 200) {
							//评价列表
							if(data['data']['evaluate'] && data['data']['evaluate'].length > 0) {
								var _html = "";
								$.each(data['data']['evaluate'], function(i, item) {
									if(i < 2) {
										_html += '<li><div class="li-top-area oh"><figure class="li-top-area-left fl"><div class="oh fl"><img src="{6}"  onerror="javascript:this.src=\'{7}\'" class="fl"></div><figcaption class="oh fl"><p>{0}</p><div class="oh"><div class="pingfen-area fl">{1}</div><p class="fl">{2}</p></div></figcaption></figure><div class="li-top-area-right fr">{3}</div></div><div class="li-bottom-area"><h3>{4}</h3><p>{5}</p></div></li>'.stringFormatObj({
											'0': $.trim(item['user_nick']) == ''?'昵称暂无':item['user_nick'],
											'1': dealStar(item['evaluate_grade']),
											'2': dealStarText(item['evaluate_grade']),
											'3': item['created'],
											'4': (item['receptiontime'] != ''||item['houserAddress'] != '')?(dealTimeKf(item['receptiontime'])+'在'+item['houserAddress']['address']+'看房'):'暂无看房数据',
											'5': item['evaluate_content'],
											'6': location.protocol+'//'+item['user_pic'],
											'7': ServerHost+'/app/images/ic_default_headpic.png'
										});
									};
								});
								$('.pingjia-list-area>ul').html(_html);
								data['data']['evaluate'] && data['data']['evaluate'].length > 2 && $('.pingjia-list-area .see-all-area').show().find('a').attr('href', ('more_pingjia?agentId='+_agentId+'&fenNum='+_fenNum+'&pingNum='+_pingNum));
							} else {
								$('.pingjia-list-area .zanwu_data').show();
							};
	
							//成交列表
							if(data['data']['journalAccounts'] && data['data']['journalAccounts'].length > 0) {
								var _html2 = "";
								$.each(data['data']['journalAccounts'], function(i, item) {
									if(i < 2) {
										_html2 += '<li class="oh"><div class="fl oh"><img src="{5}" onerror="javascript:this.src=\'{6}\'"></div><div class="fl"><h3 class="shangpu-name ellipsis">{0}</h3><p class="qianyue-time">签约时间：{1}</p><p class="mianji-scale">{2}</p><p class="zuji-price">租金均价：<span>{3}</span>元/月</p><p class="sp-text ellipsis oh">{4}</p></div></li>'.stringFormatObj({
											'0': item['title'],
											'1': item['singntime'],
											'2': dealScale(item),
											'3': item['price'],
											'4': dealTags(item['shangpu_tags']),
											'5': location.protocol+'//'+item['img'],
											'6': ServerHost+'/resource/image/pzz_.jpg'
										});
									};
								});
								$('.chengjiao-list-area>ul').html(_html2);
								data['data']['journalAccounts'] && data['data']['journalAccounts'].length > 2 && $('.chengjiao-list-area .see-all-area').show().find('a').attr('href', 'more_chengjiao?agentId=' + _agentId);
							} else {
								$('.chengjiao-list-area .zanwu_data').show();
							};
						} else {
							layerTipsX(data['msg']);
						};
					} else {
						layerTipsX('数据错误');
					};
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
					layerTipsX('error');
				},
				complete: function(xhr, textStatus) {
					loadItem.hide();
					if(textStatus === 'timeout') {
						layerTipsX('请求超时');
					};
				}
			});
		};
	};
});