<?php
/**
 * Created by PhpStorm.
 * User: fuju
 * Date: 2018/1/19
 * Time: 11:33
 */

namespace app\model;


class GHousesImgs extends BaseModel
{
    protected $table = 'g_houses_imgs';

    /**
     * 商铺图片添加
     *
     * @param $params
     * @param $house_id
     * @return array|false
     * @throws \Exception
     */
    public function add($params, $house_id)
    {
        $date = date('Y-m-d H:i:s');
        $params['create_time'] = $date;
        $params['update_time'] = $date;
        $count = 0;
        $insert_img = array();
        //1列表页封面图
        if ($params['cover']) {
            $insert_img['0']['house_id'] = $house_id;
            $insert_img['0']['img_type'] = 1;
            $insert_img['0']['img_name'] = $params['cover'];
            $insert_img['0']['create_time'] = $params['create_time'];
            $insert_img['0']['update_time'] = $params['update_time'];
            $count = count($insert_img) + 1;
        }

        //2详情页轮播图
        if ($params['slide_show']) {
            foreach ($params['slide_show'] as $k => $v) {
                $k += $count;
                $insert_img[$k]['house_id'] = $params['house_id'];
                $insert_img[$k]['img_type'] = 2;
                $insert_img[$k]['img_name'] = $v;
                $insert_img[$k]['create_time'] = $params['create_time'];
                $insert_img[$k]['update_time'] = $params['update_time'];
            }

            if (count($insert_img) > 0) {
                $count = count($insert_img) + 1;
            }
        }

        //3楼层平面图
        if ($params['plan']) {
            foreach ($params['plan'] as $kk => $vv) {
                $kk += $count;
                $insert_img[$kk]['house_id'] = $params['house_id'];
                $insert_img[$kk]['img_type'] = 3;
                $insert_img[$kk]['img_name'] = $vv;
                $insert_img[$kk]['create_time'] = $params['create_time'];
                $insert_img[$kk]['update_time'] = $params['update_time'];
            }
        }

        return $this->saveAll($insert_img);
    }

    /**
     * 商铺图片编辑
     *
     * @param $params
     * @param $house_id
     * @return array|false
     * @throws \Exception
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function edit($params, $house_id) {
        //编辑图片
        $house_img_data = $this->field('id,img_name,img_type')
            ->where('img_status <> 1 AND house_id = ' . $house_id)->select();
        $key = 0;
        $house_img_edit = array();
        $slide_show = $params['slide_show'];
        $plan = $params['plan'];

        foreach ($house_img_data as $k => $v) {
            //1列表页封面图
            if ($v->img_type == 1) {
                if ($params['cover'] != $v->img_name) {
                    /*伪删除之前的图片*/
                    $house_img_edit[$key]['id'] = $v->id;
                    $house_img_edit[$key]['img_status'] = 1;
                    $key++;
                } else {
                    /*提交图片相同清除提交的图片*/
                    $params['cover'] = 0;
                }
            }

            //2详情页轮播图
            if ($v->img_type == 2) {
                if ($slide_show != '') {
                    foreach ($slide_show as $kk => $vv) {
                        if (in_array($v->img_name,$slide_show)) {
                            $img_key = array_search($v->img_name,$params['slide_show']);//根据值查找对应的key
                            unset($params['slide_show'][$img_key]);
                        } else {
                            $house_img_edit[$key]['id'] = $v->id;
                            $house_img_edit[$key]['img_status'] = 1;
                            $key++;
                        }
                    }
                } else {
                    //伪删除全部的轮播图
                    $house_img_edit[$key]['id'] = $v->id;
                    $house_img_edit[$key]['img_status'] = 1;
                    $key++;
                }
            }

            //3楼层平面图
            if ($v->img_type == 3) {
                if ($plan != '') {
                    foreach ($plan as $kk => $vv) {
                        if (in_array($v->img_name,$plan)) {
                            $img_key = array_search($v->img_name,$params['plan']); //根据值查找对应的key
                            unset($params['plan'][$img_key]);
                        } else {
                            $house_img_edit[$key]['id'] = $v->id;
                            $house_img_edit[$key]['img_status'] = 1;
                            $key++;
                        }
                    }
                } else {
                    //伪删除全部的轮播图
                    $house_img_edit[$key]['id'] = $v->id;
                    $house_img_edit[$key]['img_status'] = 1;
                    $key++;
                }
            }
        }

        $this->add($params, $house_id);
        return $this->saveAll($house_img_edit);
    }
}