<?php

namespace app\model;


use think\Db;

class GHouses extends BaseModel
{
    protected $table = 'g_houses';

    /**
     * 通过id获取商铺详情
     *
     * @param $id
     * @return array|false|\PDOStatement|string|\think\Model
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getHouseById($id) {
        $fields = 'a.*,b.fee_rule,internal_item_advantage,external_item_advantage,tiny_brochure_url,auditorium,traffic,
                   enter_num,do_business_date,start_business_date,singn_rule,landlord_phone';
        $select_data = $this->alias('a')->field($fields)
            ->join('g_houses_ext b','a.id = b.house_id', 'left')
            ->where('a.id',$id)
            ->find();
        $data = $select_data->getData();
        $img = new GHousesImgs();
        $img_data = $img->field('id,img_type,img_name')
            ->where('img_status = 0 AND house_id = '.$id)
            ->select();

        foreach ($img_data as $k=>$v) {
            switch ($v->img_type) {
                case 1 :
                    $data['cover'] = $v;break;
                case  2 :
                    $data['slide_show'][$k] = $v;break;
                default :
                    $data['plan'][$k] = $v;
            }
        }
        return $data;
    }

    /**
     * 楼盘列表
     *
     * @param int $pageNo
     * @param int $pageSize
     * @param string $order_
     * @param string $field
     * @param string $params
     * @return mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getHouseList($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field = '', $params = '') {
        $data = $this->field($field)
            ->where($params)
            ->order($order_)
            ->limit($pageSize)
            ->page($pageNo)
            ->select();
        $house_id = array();
        foreach ($data as $k => $v) {
            $house_id[$k] = $v['id'];
        }

        $result = array();
        if (empty($house_id)) {
            $result = $data;
        } else {
            /*案场权限人*/
            $house_agents = Db::table('g_houses_to_agents')->alias('a')
                ->field('a.houses_id,b.id,b.name,b.phone')
                ->join('a_agents b', 'a.agents_id=b.id','left')
                ->where('a.houses_id','IN', implode(',',$house_id))
                ->select();

            /*盘方*/
            $house_dish = Db::table('g_houses_dish')->alias('a')
                ->field('a.houses_id,b.id,b.name,b.phone')
                ->join('a_agents b', 'a.agents_id=b.id','left')
                ->where('a.houses_id','IN', implode(',',$house_id))
                ->select();

            foreach ($data as $k=>$v) {
                $result[$k] = $v->toArray();
                foreach ($house_agents as $k2 => $v2) {
                    if ($v->id == $v2['houses_id']) {
                        $result[$k]['agents_name'][$k2]['id'] = $v2['id'];
                        $result[$k]['agents_name'][$k2]['name'] = $v2['name'];
                        $result[$k]['agents_name'][$k2]['phone'] = $v2['phone'];
                    }
                }

                foreach ($house_dish as $k3 => $v3) {
                    if ($v->id == $v3['houses_id']) {
                        $result[$k]['dish_name'][$k3]['id'] = $v3['id'];
                        $result[$k]['dish_name'][$k3]['name'] = $v3['name'];
                        $result[$k]['dish_name'][$k3]['phone'] = $v3['phone'];
                    }
                }
            }
        }

        return $result;
    }

    /**
     * 查询属于盘方的商铺列表
     *
     * @param int $pageNo
     * @param int $pageSize
     * @param string $order_
     * @param string $field
     * @param string $params
     * @return array|false|\PDOStatement|string|\think\Collection
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getHouseListDish($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field = '', $params = '') {
        $data = $this->field($field)->alias('a')
            ->join('g_houses_dish b', 'a.id=b.houses_id','left')
            ->join('a_agents c','b.agents_id=c.id','left')
            ->where($params)
            ->order($order_)
            ->limit($pageSize)
            ->page($pageNo)
            ->select();
        $house_id = array();
        foreach ($data as $k => $v) {
            $house_id[$k] = $v['id'];
        }

        $result = array();
        if (empty($house_id)) {
            $result = $data;
        } else {
            /*案场权限人*/
            $house_agents = Db::table('g_houses_to_agents')->alias('a')
                ->field('a.houses_id,b.id,b.name,b.phone')
                ->join('a_agents b', 'a.agents_id=b.id','left')
                ->where('a.houses_id','IN', implode(',',$house_id))
                ->select();

            /*盘方*/
            $house_dish = Db::table('g_houses_dish')->alias('a')
                ->field('a.houses_id,b.id,b.name,b.phone')
                ->join('a_agents b', 'a.agents_id=b.id','left')
                ->where('a.houses_id','IN', implode(',',$house_id))
                ->select();

            foreach ($data as $k=>$v) {
                $result[$k] = $v->toArray();
                foreach ($house_agents as $k2 => $v2) {
                    if ($v->id == $v2['houses_id']) {
                        $result[$k]['agents_name'][$k2]['id'] = $v2['id'];
                        $result[$k]['agents_name'][$k2]['name'] = $v2['name'];
                        $result[$k]['agents_name'][$k2]['phone'] = $v2['phone'];
                    }
                }

                foreach ($house_dish as $k3 => $v3) {
                    if ($v->id == $v3['houses_id']) {
                        $result[$k]['dish_name'][$k3]['id'] = $v3['id'];
                        $result[$k]['dish_name'][$k3]['name'] = $v3['name'];
                        $result[$k]['dish_name'][$k3]['phone'] = $v3['phone'];
                    }
                }
            }
        }
        return $result;
    }

    /**
     * 查询属于盘方的商铺列表总记录数
     *
     * @param string $params
     * @return int|string
     */
    public function getHouseListDishTotal($params = '') {
        $data = $this->alias('a')
            ->join('g_houses_dish b', 'a.id=b.houses_id','left')
            ->join('a_agents c','b.agents_id=c.id','left')
            ->where($params)
            ->count();
        return $data;
    }
}
