<?php
/**
 * Created by PhpStorm.
 * User: fuju
 * Date: 2018/1/17
 * Time: 13:46
 */

namespace app\index\controller;


use app\index\extend\Basic;
use app\model\GHouses;
use app\model\GHousesExt;
use app\model\GHousesImgs;


class Houses extends Basic
{
    public function index() {
        return view('index');
    }

    /**
     * 新增和编辑商铺
     *
     * @return \think\response\View
     * @throws \Exception
     * @throws \think\exception\PDOException
     */
    public function edit() {
        $result['code'] = 200;
        $result['msg'] = '';
        $params = $this->request->param();
        if ($this->request->isPost()) {
            $date = date('Y-m-d H:i:s');

            if ($params['id']) {
                $params['update_time'] = $date;
            }

            $house = new GHouses();
            $house->startTrans();

            //新增或编辑
            if ($params['id'] == '') {
                $house_id = $house->allowField(true)->save($params);
            } else {
                $house_id = $house->allowField(true)->isUpdate(true)->save($params, ['id' => $params['id']]);
            }
            $params['house_id'] = $house_id;
            $house_ext = new GHousesExt();

            if ($params['start_business_date']) {
                $params['start_business_date'] = date('Y-m-d H:i:s' , strtotime($params['start_business_date']));
            }

            //新增或编辑根据id
            if ($params['id'] == '') {
                $house_ext->allowField(true)->save($params);
            } else {
                $house_ext_data = $house_ext->field('id')->where('house_id',$params['id'])->find();
                $house_ext->allowField(true)->isUpdate(true)->save($params, ['id' => $house_ext_data['id']]);
            }

            /***保存图片 hujun 2018.1.19 start***/
            $house_img = new GHousesImgs();
            if ($params['id'] == '') {
                $house_img->add($params, $house_id);
            } else {
                $house_img->edit($params, $house_id);
            }
            /***保存图片 hujun 2018.1.19 end***/
            if ($house_id) {
                $house->commit();
                $return = $this->response($result['code'], $result['msg']);
            } else {
                $house->rollback();
                $return = $this->response(101, $result['msg']);
            }
        } elseif ($params['id']){

            //获取商铺详情
            $house = new GHouses();
            $result['data'] = $house->getHouseById($params['id']);
            $return = $this->response($result['code'], $result['msg'], $result['data']);
        } else {

            //商铺添加页面
            $return = view('edit');
        }
        return $return;
    }

    /**
     * 楼盘列表
     *
     * @return \think\Response
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getHouseList() {
        $data['status'] = 200;
        $data['msg']    = '';
        $params = $this->request->param();
        $pageNo   = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 15 : $params['pageSize'];

        $house = new GHouses();
        $fields = '';

        /*精选商铺--0是1否*/
        if ($params['is_carefully_chosen'] != NULL) {
            $where['is_carefully_chosen'] = $params['is_carefully_chosen'];
        }

        /*0是1否显示在c端用户*/
        if ($params['is_show'] != NULL) {
            $where['is_show'] = $params['is_show'];
        }

        /*商铺类型（0商场，1街铺）*/
        if ($params['shop_type'] != NULL) {
            $where['shop_type'] = $params['shop_type'];
        }

        /*所在城市*/
        if ($params['city'] != NULL) {
            $where['city'] = $params['city'];
        }

        /*所在区*/
        if ($params['disc'] != NULL) {
            $where['disc'] = $params['disc'];
        }

        /*状态 0待审批  1上架 2下架 3回收*/
        if ($params['status'] != NULL) {
            $where['status'] = $params['status'];
        }

        /*价格 -1表示营业额扣点 存分*/
        if ($params['rent_price'] != NULL) {
            switch ($params['rent_price']) {
                case 1:
                    $where['rent_price'] = ['>',10000];break;
                case 2:
                    $where['rent_price'] = ['between','10000,30000'];break;
                default :
                    $where['rent_price'] = ['>', '30000'];
            }
        }

        /*对内楼盘名*/
        if ($params['internal_title'] != NULL) {
            $where['internal_title'] = ['LIKE', $params['internal_title'].'%'];
        }

        /*是否独家0否1是*/
        if ($params['is_exclusive_type'] != NULL) {
            $where['is_exclusive_type'] = ['LIKE', $params['is_exclusive_type'].'%'];
        }

        /*开始时间*/
        if ($params['start_date'] != NULL) {
            $where['create_time'] = ['> time', $params['start_date']. ' 00:00:00'];
        }

        /*结束时间*/
        if ($params['end_date'] != NULL) {
            $where['create_time'] = ['< time',$params['end_date']. ' 23:59:59'];
        }

        /*开始结束时间*/
        if ($params['start_date'] != NULL && $params['end_date'] != NULL) {
            $where['create_time'] = ['between time',[$params['start_date'].' 00:00:00'],$params['end_date']. ' 23:59:59'];
        }

        /*根据库存判断是否已租*/
        if ($params['Leased'] != NULL) {
            $where['residue_num'] = $params;
        }

        if (empty($params['dish'])) {
            /*楼盘编号*/
            if ($params['id'] != NULL) {
                $where['id'] = $params['id'];
            }
            $where['status'] = ['<>',2];
            $data['data']['list'] = $house->getHouseList($pageNo, $pageSize, 'id DESC', $fields, $where);
            $data['data']['total'] = $house->getTotal($where);
        } else {
            /*楼盘编号*/
            if ($params['id'] != NULL) {
                $where['a.id'] = $params['id'];
            }
            $where['a.status'] = ['<>',2];
            $where['c.name'] = ['LIKE',$params['dish'].'%'];
            $data['data']['list'] = $house->getHouseListDish($pageNo, $pageSize, 'a.id DESC', $fields, $where);
            $data['data']['total'] = $house->getHouseListDishTotal($where);
        }

        return $this->response($data['status'], $data['msg'], $data['data']);
    }

    public function del() {

    }
}