<?php
/**
 * Created by PhpStorm.
 * User: hujun
 * Date: 2018/1/16
 * Time: 13:51
 */

namespace app\index\controller;

use app\index\extend\Basic;
use app\model\AuthGroup;
class Auth extends Basic
{


    /**
     * 权限列表页
     * 
     * @return type
     */
    public function index(){
        return view('index');
    }
    

    /**
     * 权限分配
     * 
     * @param type $group_id
     */
    public function access($group_id = 0) {
        return view('access');
    }

    /**
     * 用户组授权用户列表
     * 
     * @param type $group_id
     */
    public function accessUser($group_id = 0) {
        return view('accessUser');
    }

    public function getAuth() {
        $data['status'] = 200;
        $data['msg'] = '';

        $params = $this->request->param();
        $pageNo = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 15 : $params['pageSize'];
        $auth_group = New AuthGroup();
        $where = 'status <> 0';
        $data['list'] = $auth_group->getList($pageNo, $pageSize, '','*', $where);
        $data['total'] = $auth_group->getTotal($where);
        return $this->response(200, '', $data);
    }

    /**
     * 角色编辑
     */
    public function roleedit() {
        //$this->assign('type','1');
        // return $this->display();
        return view('roleedit');
    }

    /**
     * 验证数据
     * @param  string $validate 验证器名或者验证规则数组
     * @param  array  $data          [description]
     * @return [type]                [description]
     */
    protected function validateData($data,$validate)
    {
        if (!$validate || empty($data)) return false;
        $result = $this->validate($data,$validate);
        if(true !== $result){
            // 验证失败 输出错误信息
            return $result;
        }
        return 1;

    }

   //添加角色
    public function  addAuth($group_id=0){
        $data['status'] = 200;
        $data['msg'] = '';
        $title = $group_id ? '编辑':'新增';
        $table= New AuthGroup();
        $info= $table->find();

        if (empty($group_id)) {
            $data = input('post.');
            $err=$this->validateData($data,
                [
                    ['title','require|chsAlpha','用户组名称不能为空|用户组名称只能是汉字和字母'],
                    ['description','chsAlphaNum','描述只能是汉字字母数字']
                ]
            );

           if($err!=1){
               return $this->response(100, $err);
           }
            $id   = isset($data['id']) && $data['id']>0 ? $data['id']:false;

            if ($table->editData($data,$id)) {
                return $this->response(200, '成功');
            } else {
                return $this->response(101, '失败');

            }

        } else {
            return $this->response(200, $title, $info);


        }
    }
   
}