define (['doT', 'text!temp/watch_template_tpl.html', 'css!style/home.css',"datetimepicker",'pagination','bootstrapJs'], function (doT, template) {
    user = {
        pageNo: 1, /*第几页*/
        pageSize: 10, /*每页显示多少条*/

        father_id : '',
        agents_id : '',
        watch_id  : '',
        urls: '',
        init: function () {
            //初始化dot
            $ ("body").append (template);
            user.getList ();
            user.event ();
        },
        event: function () {
            $("#form_search_reset").click(function () {
                document.getElementById("form_search").reset();
            });
            $("#search").click(function () {
                user.getList(1);
            });

            $("#submit_follow").click(function () {
                user.addFollow();
            });
            $('#datetimepicker').datetimepicker({
                format: 'yyyy-MM-dd',
                language: 'zh-CN',
                pickTime: false
            }).on('changeDate',function(){
                $(this).datetimepicker('hide');
            });

            $ (document).delegate (".phone_jia", "click", function () {
                /*手机检索姓名*/
                var ldHtml = $('.phone_list');
                var stopstatus = true;
                var valueCurrent = '';
                var ajaxObj;
                $(function() {
                    $(document).on('input','.phone_jia', function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        var _this = $(this);
                        _this.next().css("display","block");
                        valueCurrent = _this.val();
                        if(valueCurrent != ''){
                            resetLoad();
                            loadMain(valueCurrent,_this.next());
                        }else{
                            ldHtml.html('');
                            return false;
                        }

                    });

                });

                function resetLoad(){
                    if(ajaxObj){
                        ajaxObj.abort();
                    }
                    ldHtml.html('');
                    stopstatus = true;
                }
                function loadMain(phone, obj) {
                    ajaxObj=$.ajax({
                        type: "GET",
                        url: '/index/getBroker' ,
                        data: {
                            'phone': phone
                        },
                        timeout: 10000,
                        dataType: "json",
                        beforeSend: function() {
                        },
                        success: function(data) {

                            if(data.code === 200){
                                $("#agents_list").show();
                                var _html = '';
                                $.each(data.data, function(i,data) {
                                    _html += '<li class="addphone"><span class="id">'+data['id']
                                    +'-</span><span class="phone_name">'+data['realname']
                                    +'</span><span class="phone_span">-</span><span class="phone-phone">'
                                    +data['phone']+'</span><span class="hidden father_id">'
                                    +data['father_id']+'</span></li>';
                                });                                       
                                $("#agents_list").html(_html);
                            }
                        },
                        error: function() {

                        },
                        complete: function(xhr, textStatus) {
                            if(textStatus === "timeout") {
                                /*处理超时的逻辑*/
                                alert("请求超时");
                            }
                        }
                    });
                }
            });

            /*选择经纪人*/
            $ (document).delegate (".addphone", "click", function () {
                user.addphone($(this));
            });

            $ (document).delegate (".add_applies", "click", function () {
                user.watch_id =  $(this).attr ("data-id");
                $("input[name='phone']").val('');
            });   

            $ (document).delegate ("#submit_applies", "click", function () {
                if ($('input[name="phone"]').val() == '') {
                    alert('报备人信息不能为空');
                    return ;
                }
                var params = {};
                params.shop_id   = user.father_id;                
                params.agents_id = user.agents_id;                
                params.watch_id  = user.watch_id;                
                $.ajax ({
                    url: '/index/add_applies',
                    type: 'POST',
                    async: true,
                    data: params,
                    dataType: 'json',
                    success: function (data) {
                        if (data.code == 200) {
                            alert(data.msg);
                            $("#modal-watch").modal ('hide');
                            user.getList(1);
                        } else {
                            alert(data.msg);
                        }
                    }
                });
            });

        },
        getList: function (pageNo) {
            user.pageNo   = pageNo;
            var params    = {};
            params.start_date   = $("#start_date").val();
            params.end_date     = $("#end_date").val();
            params.name   = $("#name").val();
            params.phone  = $("#phone").val();
            params.shop_name   = $("#shop_name").val();
            params.pageNo   = user.pageNo;
            params.pageSize = user.pageSize;

            $.ajax ({
                url: '/index/get_watch',
                type: 'GET',
                async: true,
                data: params,
                dataType: 'json',
                success: function (data) {
                    var temp = document.getElementById ('watch_list_tpl').innerHTML;
                    var doTtmpl = doT.template (temp);
                    $ ("#sublet_list").html (doTtmpl (data.data.list));

                    /*分页代码*/
                    $ ("#pagediv").pagination ({
                        length: data.data.total,
                        current: pageNo,
                        every: user.pageSize,
                        onClick: function (el) {
                            user.getList (el.num.current);
                        }
                    });
                }
            });
        },
        addFollow : function () {
            var params = {};
            params.type = 2;
            params.id   = id;
            params.content = $("#content").val();

            $.ajax ({
                url: '/index/addFollow',
                type: 'POST',
                async: true,
                data: params,
                dataType: 'json',
                success: function (data) {
                    if (data.code == 200) {
                        $ ("#modal-process").modal ('hide');
                    } else {
                        alert(data.msg);
                    }
                }
            });
        },
        addphone : function(obj) {
            var phone_name= $(obj).find(".phone_name").html();
            var phone_phone= $(obj).find(".phone-phone").html();
            var phone_span= $(obj).find(".phone_span").html();
            var id= $(obj).find(".id").html();
            var val = id+phone_name+phone_span+phone_phone;
            user.father_id = $(obj).find(".father_id").html();
            user.agents_id = id.substring(0,id.length-1)
            $("input[name='phone']").val(val);
            $(obj).parent().hide();
            $("#agents_list").html('');
            return ;
        }
    };
    return user;
});

var id;

function alertFollow(obj){
    id = $(obj).attr ("data-id");
    $("#content").val('');
    $.ajax ({
        url: '/index/followList',
        type: 'GET',
        async: true,
        data: {"id":id,"type":2},
        dataType: 'json',
        success: function (data) {
            if (data.code == 200) {
                var str = '';
                $.each(data.data, function (i,item) {
                    str += "<tr><td>"+item['content']+"</td><td>"+item['admin_name']+"</td><td>"+item['create_time']+"</td></tr>";
                    $("#list_follow").html(str);
                });
            } else {
                alert(data.msg);
            }
        }
    });
}

