<?php

namespace app\model;


use think\Model;


class HouseInfos extends Model
{
    protected $table = 'houseinfos';
    protected $dbHouseInfo;

    function __construct()
    {
        $this->dbHouseInfo = Db($this->table);
    }

    /**
     * 获取商铺列表
     * @param int $pageNo
     * @param int $pageSize
     * @param string $order_
     * @param $field
     * @param $params
     * @return false|\PDOStatement|string|\think\Collection
     */
    function getHouseInfoList($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field, $params)
    {
        return $data = $this->dbHouseInfo
            ->field($field)
            ->where($params)
            ->order($order_)
            ->limit($pageSize)
            ->page($pageNo)
            ->select();
    }

    /**
     * 获取月均价
     * @return float
     */
    function getAveragePrice()
    {
        //price
        $params['rent_type'] = array( "eq", 1 ); //月租金类型
        $params['room_num_left'] = array( "<>", 0 );//剩余店铺为0的不算

        $sumPrice = $this->dbHouseInfo
            ->where($params)
            ->sum("price");

        $count_ = $this->dbHouseInfo
            ->field("id")
            ->where($params)
            ->count("id");
        $averagePrice = round($sumPrice / $count_);
        return $averagePrice;
    }

    /**
     * 获取商铺详情
     * @param $field
     * @param $params
     * @return mixed
     */
    function getHouseDetail($field, $params)
    {
        return $data = $this->dbHouseInfo
            ->field($field)
            ->where($params)
            ->find($params["id"]);
    }


    function getCityList( $field, $params, $group)
    {
        return $data = $this->dbHouseInfo
            ->field($field)
            ->where($params)
            ->group($group)
            ->select();
    }


}
