<?php

namespace app\index\controller;

use app\index\extend\Basic;
use app\model\AdminModel;
use think\Request;
use think\Session;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2017/12/20
 * Time : 13:52
 * Intro:c端后台登录
 */
class Login extends Basic
{

    protected $loginDb;

    public function __construct($request = null)
    {
        parent::__construct($request);
        $this->loginDb = new AdminModel();
    }

    public function login()
    {
        return view("/login/login");
    }

    /**
     * 登陆验证
     * @return \think\response\View
     */
    public function loginVerify()
    {
        $name = $_POST["username"];
        $passwd = $_POST["passwd"];
        if (!isset($name) || !isset($passwd)) {
            return view("/login/login", [ "msg" => "用户名或密码不能为空" ]);
        }
        $params["name"] = $name;
        $params["pswd"] = md5(md5($passwd));
        $result = $this->loginDb->verifyUser($params);

        if (count($result) > 0) {
            //todo 更新登录信息
            $this->loginDb->updateLoginTime($result[0]["id"]);

            Session::set("userName",$result[0]["name"]);
            Session::set("userId",$result[0]["id"]);
            Session::set("lastLoginTime",time());

            $this->redirect('/admin.php/index/banner');
        } else {
            return view("/login/login", [ "msg" => "用户名或密码错误" ]);
        }

    }

    /**
     * 退出
     *
     * @return \think\response\View
     */
    public function logout()
    {
        Session::clear();
        return view("/login/login", [ "msg" => "退出成功" ]);
    }
}