<?php

namespace app\model;

use think\Model;
use think\Db;

class SubletModel extends Model
{
    // 设置当前模型对应的完整数据表名称
    protected $table = 'u_sublet';
    protected $db;

    function __construct()
    {
        $this->db = Db($this->table);
    }

    public function addSublet($param)
    {
        Db::startTrans();
        try {
            $id = $this->save($param);
            Db::commit();
            return [ "code" => "200", "msg" => $id ];
        } catch (\Exception $e) {
            Db::rollback();
            return [ "code" => "101", "msg" => "失败，数据异常" ];
        }


    }

    /**
     * 查询转铺记录
     *
     * @param int $pageNo
     * @param int $pageSize
     * @param string $order_
     * @param string $fields
     * @param string $params
     * @return false|\PDOStatement|string|\think\Collection
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getSublet($pageNo = 1, $pageSize = 15, $order_ = '', $fields = '*', $params = '') {
        $result = $this->field($fields)
            ->where($params)
            ->order($order_)
            ->limit($pageSize)
            ->page($pageNo)
            ->select();
        return $result;
    }

    /**
     * 查询转铺总记录数
     *
     * @param $params
     * @return int|string
     */
    public function getSubletTotal($params) {
        $result = $this->where($params)->count();
        return $result;
    }

    /**
     * 根据用户id和楼盘id获取用户是否转租
     * @param $params
     * @return false|\PDOStatement|string|\think\Collection
     */
    public function getSubletByHoseId( $params ) {
        return $this->field("id,status")
            ->where($params)
            ->select();
    }
}
