<?php
/**
 * Created by PhpStorm.
 * User: fuju
 * Date: 2018/1/17
 * Time: 15:44
 */

namespace app\model;


use think\Model;

class BaseModel extends Model
{
    /**
     * 记录总数
     *
     * @param $params
     * @return int|string
     */
    public function getTotal($params)
    {
        return  $this->where($params)->count();
    }

    /**
     * 新增或编辑数据
     * @param  array/object  $data 来源数据
     * @param  boolean $kv   主键值
     * @param  string  $key  主键名
     * @return [type]        执行结果
     */
    public function editData($data,$kv=false,$key='id',$confirm=false)
    {
        $this->allowField(true);

        if ($confirm) {//是否验证

            $this->validate($confirm);

        }

        if($kv){//编辑

            $res=$this->save($data,[$key=>$kv]);

        }else{

            $res=$this->data($data)->save();

        }

        return $res;
    }

    /**
     * 列表
     *
     * @param type $pageNo
     * @param type $pageSize
     * @param type $order_
     * @param type $field
     * @param type $params
     * @return type
     */
    public function getList($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field = '', $params = '') {
        return $this->field($field)
            ->where($params)
            ->order($order_)
            ->limit($pageSize)
            ->page($pageNo)
            ->select();
    }

}