<?php

namespace app\index\controller;

use app\index\extend\Basic;
use app\model\AAgents;
use app\model\AdminModel;
use app\model\AuthRule;
use think\Request;
use think\Session;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2017/12/20
 * Time : 13:52
 * Intro:c端后台登录
 */
class Login extends Basic
{

    protected $loginDb;
    protected $loginagent;
    protected $authrule;
    public function __construct($request = null)
    {
        parent::__construct($request);
        $this->loginDb = new AdminModel();
        $this->loginagent=new AAgents();
        $this->authrule=new AuthRule();
    }

    public function login()
    {
        return view("/login/login");
    }

    /**
     * 登陆验证
     * @return \think\response\View
     */
    public function loginVerify()
    {
        $name = $_POST["username"];
        $passwd = $_POST["passwd"];
        if (!isset($name) || !isset($passwd)) {
            return view("/login/login", [ "msg" => "用户名或密码不能为空" ]);
        }
        if($name=='admin'){
            $params["name"] = $name;
            $params["pswd"] = md5(md5($passwd));
            $result = $this->loginDb->verifyUser($params);

            if (count($result) > 0) {
                //todo 更新登录信息
                $this->loginDb->updateLoginTime($result[0]["id"]);

                Session::set("userName",$result[0]["name"]);
                Session::set("userId",$result[0]["id"]);
                Session::set("lastLoginTime",time());
                $this->operating_records($result[0]["id"],1,'后台登陆'); //记录操作日志
                $this->redirect('/admin.php/index/banner');
            } else {
                return view("/login/login", [ "msg" => "用户名或密码错误" ]);
            }
        }else{
            //条件
            $filed=" a.id,a.store_id,a.auth_group_id,a.district_id,a.level,a.name,a.phone,a.sex,a.img,a.status,a.admin_off,
                    ifnull(s.store_name,'')store_name,ifnull(d.district_name,'')district_name,g.rules";
            $join=[
            ['a_store s', ' a.store_id=a.id','left'],
            ['a_district d','a.district_id=d.id','left'],
            ['auth_group g','a.auth_group_id=g.id','left']
        ];
            $params["name"] = $name;
            $passwd = md5($passwd);
            $where="(name='{$name}'or phone='{$name}') and  password='$passwd' ";
            $list=$this->loginagent->verifyUser($filed,$join,$where);
            if(!$list){
                 return view("/login/login", [ "msg" => "用户名或密码错误" ]);
            }
            //prt($list->toArray());//转化arr
            if($list['admin_off']!='0'||empty($list['rules'])){
                 return view("/login/login", [ "msg" => "用户无后台访问权限" ]);
            }else{
                $rules=trim($list['rules'],',');
                $where ="id in({$rules})and is_menu=1 and status=1 and pid=1 ";
                $nav=$this->authrule->loginRule($where);
                //$nav=collection($nav)->toArray();//转化arr
                $nav2=array();
                $url='';//跳转页面
                foreach ($nav as $k=> $v){
                    if($k=='0'){
                        $url=$v->name;
                    }
                   $nav2[$v->id]=$v;
                }
                //搜索菜单功能
                   $where ="id in({$rules}) and is_menu=0 and status=1  ";
                   $r= $this->authrule->loginRule($where);
                 $r2='';
                 foreach($r as $v){
                    $r2[$v->pid][]=$v;
                 }
                foreach($nav2 as $k=> $v){
                    if($r2[$k]){
                        $nav2[$k]['cz']=$r2[$k];
                    }
                }
                $list['nav']=$nav2;
               $list2= $list->toArray();//转化arr

            }
           // Session::delete("userinfo");
            Session::set("userName",$list["name"]);
            Session::set("userId",$list["id"]);
            Session::set("userinfo",$list2);
            Session::set("lastLoginTime",time());

            $this->operating_records($list["id"],1,'后台登陆'); //记录操作日志
            $this->redirect('/admin.php/'.$url);
            
            
            
        }


    }

    /**
     * 退出
     *
     * @return \think\response\View
     */
    public function logout()
    {
        Session::clear();
        return view("/login/login", [ "msg" => "退出成功" ]);
    }
}