<?php

namespace app\model;

use think\Db;
use think\Model;

class HouseInfos extends Model
{
    protected $table = 'houseinfos';
    protected $dbHouseInfo;

    function __construct()
    {
        $this->dbHouseInfo = Db::table($this->table);
    }

    /**
     * 获取商铺列表
     * @param int $pageNo
     * @param int $pageSize
     * @param string $order_
     * @param $field
     * @param $params
     * @return false|\PDOStatement|string|\think\Collection
     */
    function getHouseInfoList($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field, $params)
    {
        return $data = $this->dbHouseInfo
            ->field($field)
            ->where($params)
            ->order($order_)
            ->limit($pageSize)
            ->page($pageNo)
            ->select();

    }

    function getAveragePrice()
    {//price
        $params['rent_type'] = array( "eq", 1 ); //月租金类型
        $params['room_num_left'] = array("<>",0);//剩余店铺为0的不算

        $sumPrice = $this->dbHouseInfo
            ->where($params)
            ->sum("price");
       $count_ = $this->dbHouseInfo
            ->field("id")
            ->where($params)
            ->count("id");

        $averagePrice = ceil($sumPrice / $count_);
        return $averagePrice;
    }

}
