var ServerHost = location.origin;
//从location.href里获取参数
function getUrlParam(name) {
	var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
	var r = decodeURI(window.location.search).substr(1).match(reg);
	if(r != null) return unescape(r[2]);
	return null;
}

function getUrlStringParam(str, name) {
	var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
	var r = str.split('?')[1].match(reg);
	if(r != null) return unescape(r[2]);
	return null;
}

//手机号码格式正则验证 by xishifeng
function is_mobile(text) {
	/^1[34578]\d{9}$/.test(text)?1:0;
}

//device判断设备是安卓还是苹果 by xishfieng 2017.04.26
var device = {
	isAndroid: function() {
		var u = navigator.userAgent;
		return (u.indexOf('Android') > -1 || u.indexOf('Linux') > -1)?true:false;
	},
	isIos: function() {
		var u = navigator.userAgent;
		return (u.indexOf('iPhone') > -1)?true:false;
	}
}

//Compatible,js向ios,android传递参数的封装  by xishfieng 2017.04.27
function Compatible(obj) {
	if(device.isIos()) {
		try {
			if(obj['hrefIos'] === undefined || obj['hrefIos'] === ''){
				window.webkit.messageHandlers.AppModel.postMessage(obj.paraIos); //webkit.messageHandlers.AppModel.postMessage可以直接调用，ios系统都支持
			}else if(obj['hrefIos'] !== null){
				window.location.href = obj['hrefIos'];
			}
		} catch(e) {
			obj.fn();
		}
	} else if(device.isAndroid()) {
		try {
			obj.fnAndroid(); //android.backPressed()是安卓提供的方法,定义在webview里
		} catch(e) {
			//alert(e.name + '\n' + e.message);
			obj.fn();
		}
	} else {
		console.log("other device");
		obj.fn();
	}
};
//封装结束

//app_h5_token的方法封装
//xishifeng 2017-05-08
//同联和福居的有区别
function h5Page(token, fn) {
	$.ajax({
		type: "post",
		url: ServerHost + "/AppTab5/about_Token",
		data: {
			'token': token
		},
		dataType: "json",
		success: function(data) {
			if(typeof data === 'object'){
				if(data['status'] == '0'){
					console.log(data.msg);
					setLoginStorage(data, token, 'agents');
					fn(data);
				}else{
					try{
						layer.open({
							content: data.msg,
							skin: 'msg',
							time: 2
						});
					}catch(e){
						alert(data.msg);
					}

				}
			}else{
				try{
					layer.open({
						content: 'token验证接口数据错误',
						skin: 'msg',
						time: 2
					});
				}catch(e){
					alert('token验证接口数据错误');
				}
			};
		},
		error: function() {
			console.warn("获取token失败");
		}
	});
}

//每次登录时设置缓存数据 by xishifeng
function setLoginStorage(data, _token, _usertable){
	//每次登录成功，记录下token,用户身份类别,id,level
	localStorage.setItem("token",_token);//存储登录的token值
	localStorage.setItem("openid",data.user.device_id);
	localStorage.setItem("usertable",_usertable);//存储身份类型
	if(_usertable === "agents"){
		//不是案场人员
		localStorage.setItem("level",data.user.level);//不是案场人员时存储身份类型
		localStorage.removeItem("roleId");
		localStorage.setItem("realname",data.user.realname);//存储用户名字
	}else if(_usertable === "admins"){
		//案场人员
		localStorage.setItem("roleId",data.user.role_id);//案场人员时存储role_id
		localStorage.removeItem("level");
		localStorage.setItem("realname",data.user.username);//存储用户名字
	}
	localStorage.setItem("id",data.user.id);//存储用户id
	localStorage.setItem("phone",data.user.phone);//存储用户名字
	localStorage.setItem('userinfo',encodeURIComponent(JSON.stringify(data['user'])));//存储用户所有信息
}

//每次退出清除登录时设置的某些缓存数据 by xishifeng
function clearLoginStorage(data, _token, _usertable){
	localStorage.removeItem("token");
	localStorage.removeItem("weixin");
	localStorage.removeItem("openid");
	localStorage.removeItem("usertable");
	localStorage.removeItem("level");
	localStorage.removeItem("roleId");
	localStorage.removeItem("id");
	localStorage.removeItem("realname");
	localStorage.removeItem("phone");
	localStorage.removeItem('userinfo');
}

//字符串格式化
String.prototype.stringFormat = function(){
	var formatted = this;
	for(var i = 0;i < arguments.length;i++){
		var _regexp = new RegExp('\\{'+ i + '\\}','gi');
		formatted = formatted.replace(_regexp, arguments[i]);
	};
	return formatted;
}

//字符串格式化,参数为对象的形式 by xishifeng 2017-07-14
String.prototype.stringFormatObj = function(){
	var formatted = this;
	for(var i in arguments[0]){
		var _regexp = new RegExp('\\{'+ i + '\\}','gi');
		formatted = formatted.replace(_regexp, arguments[0][i]);
	}
	return formatted;
};

//处理日期时间数字等
function dealDate(num) {
	return num < 10 ? ('0' + num) : ('' + num);
}

function hideTel(str){
	if(str !== '' && str !== null && str !== undefined){
		var _arr = String(str).split('');
		_arr.splice(3,4,'****');
		return _arr.join('');
	}else{
		return str;
	}	
}