require.config ({
    'baseUrl': (location.origin || location.protocol + '//' + location.hostname + (location.port == 80 ? '' : ':' + location.port)) + '/resource',

    'waitSeconds': 0,

    'paths': {
        'app': 'js',
        'jquery': 'lib/js/jquery-2.0.3.min',
        'temp': (location.origin || location.protocol + '//' + location.hostname + (location.port == 80 ? '' : ':' + location.port)) + '/resource/template',
        'style': 'css',
        'doT': 'lib/js/doT',
        'ckfinder': 'lib/Ckfinder/ckfinder',
        'ckfinderStart' : 'lib/js/ckfinderStart'
    },
    'shim': {
        'jquery': {
            'exports': 'jquery'
        },
        'doT': {
            'exports': 'doT'
        },
        'ckfinder': {
            'exports': 'ckfinder'
        },
        'ckfinderStart': {
            'exports': 'ckfinderStart'
        }
    },
    'map': {
        '*': {
            'css': 'lib/js/css.min',
            'text': 'lib/js/text',
            'doT': 'lib/js/doT'
        }
    }
});

require (['require', 'jquery', 'doT', 'app/public','ckfinder','ckfinderStart']);
