<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006~2016 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
use think\Route;

Route::rule('/','index/login/login');

Route::group('app', [
    'index' => [ 'app/index/index', [ 'method' => 'get' ] ],
    'agent_detail' => [ 'app/index/agent_detail', [ 'method' => 'get' ] ],
    'more_pingjia' => [ 'app/index/more_pingjia', [ 'method' => 'get' ] ],
    'more_chengjiao' => [ 'app/index/more_chengjiao', [ 'method' => 'get' ] ],
    'share_detail' => [ 'app/index/share_detail', [ 'method' => 'get' ] ],
    'share_register' => [ 'app/index/share_register', [ 'method' => 'get' ] ],
    'agreement' => [ 'app/index/agreement', [ 'method' => 'get' ] ],
    'agreement_app' => [ 'app/index/agreement_app', [ 'method' => 'get' ] ],
     'download' => [ 'app/index/download', [ 'method' => 'get' ] ],
    'getShopDetails' => [ 'app/index/getShopDetail', [ 'method' => 'get | post' ] ],
    'getVersionNo' => [ 'app/index/getVersionNo', [ 'method' => 'get | post' ] ],
]);


Route::group('index', [
    'member' => [ 'index/member.index/member', [ 'method' => 'get' ] ],
    'preview_list' => [ 'index/member.index/preview_list', [ 'method' => 'get' ] ],
    'consumer_list' => [ 'index/member.index/consumer_list', [ 'method' => 'get' ] ],
    'diagram_list' => [ 'index/member.index/diagram_list', [ 'method' => 'get' ] ],
    'entrust_list' => [ 'index/member.index/entrust_list', [ 'method' => 'get' ] ],

    //banner模块
    'banner' => [ 'index/banner/index', [ 'method' => 'get' ] ],
    'bannerList' => [ 'index/banner/getBannerList', [ 'method' => 'post' ] ],
    'addOrSave' => [ 'index/banner/addOrSave', [ 'method' => 'post' ] ],
    'upIsShow' => [ 'index/banner/upIsShow', [ 'method' => 'post' ] ],

    //user列表
    'usersList'  => ['index/member/getUserList',['method'=>'get']],
    'users_list' => ['index/member/index'],
    'user_add'   => ['index/member/user_add',['method'=>'post']],
    'del_user'   => ['index/member/delUser',['method'=>'post']],

    //transfer转铺列表
    'transfer_list' => ['index/transfer/index', ['method' => 'get']],
    'get_transfer'  => ['index/transfer/getlist', ['method' => 'get']],
    'putAway' => ['index/transfer/putAway', ['method'=>'post']],   //上下架转租商铺
    'addFollow' => ['index/transfer/addFollow',['method'=>'post']],  //添加跟进
    'followList' => ['index/transfer/followList',['method'=>'get']],  //跟进记录

    //login
    'login' => ['index/login/login',['method'=>'get']],
    'loginVerify' => ['index/login/loginVerify',['method'=>'post|get']],
    'logout' =>['index/login/logout',['method'=>'get']],  //退出
    //watchshop 预约看铺
    'watch_shop' => ['index/WatchShop/index',['method'=>'get']],
    'get_watch'  => ['index/WatchShop/getList',['method'=>'get']],
    'add_applies'  => ['index/WatchShop/addApplies',['method'=>'post']],

    //查询经纪人
    'getBroker'  => ['index/broker/getBroker',['method'=>'get']],

    //版本管理
    'version'  => ['index/version/index',['method'=>'get']],
    'getVersionNo'  => ['index/version/getVersionNo',['method'=>'post']],
    'getVersionList'  => ['index/version/getVersionList',['method'=>'post']],
    'addVersion'  => ['index/version/addVersion',['method'=>'post']],
]);


Route::group('api', [
    //get
    'sendSms/:phone' => [ 'api/member/sendSms', [ 'method' => 'get' ] ],   //发送短信
    'sendSms' => [ 'api/member/sendSms', [ 'method' => 'get' ] ],   //发送短信
    'index' => [ 'api/member/index', [ 'method' => 'get' ] ],


    //get broker
    'getBroker' => [ 'api/broker/index', [ 'method' => 'get' ] ],        //获取当前商铺或街铺的经纪人评论信息列表
    'commentAndDeal' => [ 'api/broker/commentAndDeal', [ 'method' => 'get' ] ],        //获取当前经纪人的评价和交易列表
    'brokerDetail' => [ 'api/broker/brokerDetail', [ 'method' => 'get' ] ],   //经纪人详情
    //post broker
    'appraiser' => [ 'api/broker/appraiser', [ 'method' => 'post' ] ],    //评价经纪人

    //get member
    'logout' => [ 'api/member/logout', [ 'method' => 'get' ] ],
    'inviteList/:id' => [ 'api/member/inviteList', [ 'method' => 'get' ] ], //邀请记录
    'qrCode' => [ 'api/member/qrCode', [ 'method' => 'get' ] ], //邀请二维码
    'getUserInfo' => ['api/member/getUserInfo',['method'=>'get']],  //通过AuthToken获取用户信息编辑用


    //post member
    'login' => [ 'api/member/login', [ 'method' => 'post' ] ],           //c端登陆
    'register' => [ 'api/member/register', [ 'method' => 'post' ] ],  //注册|邀请注册|编辑
    'uploadHeadImg' =>['api/member/uploadHeadImg',['method'=>'post']],  //头像上传

    // shop
    'shopList' => [ 'api/shop/getShopList', [ 'method' => 'post' ] ],
    'filtrateCondition' => [ 'api/shop/filtrateCondition', [ 'method' => 'get | post' ] ],
    'shopDetail' => [ 'api/shop/getShopDetail', [ 'method' => 'get' ] ],

    //get banner
    'bannerList' => [ 'api/banner/getBannerList', [ 'method' => 'get' ] ],

    //get index
    'averagePriceAndTurnover' => [ 'api/index/averagePriceAndTurnover', [ 'method' => 'get' ] ],


    //post AppointmentTime
    'getAppointmentSeeShopList' => [ 'api/appointmentTime/getAppointmentSeeShopList', [ 'method' => 'post' ] ],
    'addAppointmentSeeShop' => [ 'api/appointmentTime/addAppointmentSeeShop', [ 'method' => 'post|get' ] ],


    //tradeLog
    'getTradeList' => [ 'api/TradeLog/getTradeList', [ 'method' => 'post|get' ] ],

    //AttentionShop
    'addOrUpdateAttention' => [ 'api/AttentionShop/addOrUpdateAttention', [ 'method' => 'post|get' ] ],
    'attentionList' => [ 'api/AttentionShop/attentionList', [ 'method' => 'post | get' ] ],



    'addSublet' => [ 'api/Sublet/addSublet', [ 'method' => 'post|get' ] ],


    //Version
    'getVersionNo' => [ 'api/Version/getVersionNo', [ 'method' => 'post' ] ],


]);

//Route::miss('api/index/miss');//处理错误的url