<?php
/**
 * Created by PhpStorm.
 * User: fuju
 * Date: 2017/12/21
 * Time: 14:36
 */

namespace app\index\controller;


use app\api\untils\GeTuiUntils;
use app\index\extend\Basic;
use app\model\Agents;
use app\model\Applies;
use app\model\AppointWatchShop;
use app\model\HouseInfos;
use app\model\Remarks;
use think\Session;

class WatchShop extends Basic
{
    public function index(){
        return view('watch_shop/watch_list');
    }

    public function getList() {
        $data['status'] = 200;
        $data['msg']    = '';

        $params = $this->request->param();
        $pageNo   = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 15 : $params['pageSize'];

        $where = array();

        if (!empty($params['start_date']) && empty($params['end_date'])) {
            $where['create_time'] = ['> time', $params['start_date']];
        }

        if (!empty($params['end_date']) && empty($params['start_date'])) {
            $where['create_time'] = ['< time', $params['end_date']];
        }

        if (!empty($params['start_date']) && !empty($params['end_date'])) {
            $where['create_time'] = ['between time', [$params['start_date'],$params['end_date']]];
        }

        if (!empty($params['name'])) {
            $where['appellation'] = ['like', $params['name'].'%'];
        }

        if (!empty($params['phone'])) {
            $where['phone'] = ['like', $params['phone'].'%'];
        }

        if (!empty($params['house_title'])) {
            $where['house_title'] = ['like', $params['house_title'].'%'];
        }

        $applies = new AppointWatchShop();

        $data['list'] = $applies->getAppointWatchShopList($pageNo, $pageSize, 'id DESC', '*', $where);
        $data['total'] = $applies->getAppointWatchShopListTotal($where);
        return $this->response($data['status'], $data['msg'], $data);
    }

    public function addApplies() {
        $data['status'] = 200;
        $data['msg']    = '';

        $params = $this->request->param();

        if ($params['watch_id'] && $params['shop_id'] && $params['agents_id']) {

            $appoint_watch = new AppointWatchShop();
            $appoint_watch->startTrans();
            $apponit_data = $appoint_watch->lock(true)->where('id',$params['watch_id'])->find();

            if ($apponit_data['id']) {
                $apples = new Applies();
                $apples->data([
                    'agent_id' => $params['agents_id'],
                    'house_id' => $apponit_data['house_id'],
                    'customer' => $apponit_data['appellation'],
                    'phpone' => $apponit_data['phone'],
                    'go_off' => date('Y-m-d H:i:s', strtotime($apponit_data['expect_time'])),
                    'agent_shop_id' => $params['shop_id'],
                    'transaction_status' => 0,
                    'invite_id'      => 0,
                    'marketgroup_id' => 0,
                    'created' => date("Y-m-d H:i:s")
                ])->save();

                $remark = new Remarks();
                $remark->data([
                    'apply_id' => $apples->id,
                    'shopuser_id' => $params['agents_id'],
                    'shop_id'     => $params['shop_id'],
                    'house_id'    => $apponit_data['house_id'],
                    'transaction_status' => 0,
                    'created' => date("Y-m-d H:i:s")
                ])->save();

                $appoint_watch->save([
                    'agents_id' => $params['agents_id'],
                    'applies_id' => $apples->id
                ],['id'=>$apponit_data['id']]);

                if ($apples->id && $remark->id) {
                    $appoint_watch->commit();

                    //推送报备信息
                    $agent = new Agents();
                    $agentData = $agent->field('id,device_id,realname,agentshopname,sub_shopname')->where('id',$params['agents_id'])->find();
                    $title   = '报备提醒';
                    $content = '【'.$agentData['agentshopname'].$agentData['sub_shopname']. '-' . $agentData['realname'] . '】报备了【' . $apponit_data['house_title'].'】';
                    $get = new GeTuiUntils();
                    $req = $get->public_push_message_for_one($params['agents_id'],$agentData['device_id'],$title,$content);
                    $data['status'] = 200;
                    $data['msg']    = $req['result'] == 'ok' ? '报备成功并通知经纪人' : '报备成功，请通知经纪人';
                } else {
                    $appoint_watch->rollback();
                    $data['status'] = 101;
                    $data['msg']    = '报备失败';
                }

            } else {
               $data['msg']    = '没有该铺信息';
               $data['status'] = 101;
            }
        } else {
            $data['msg'] = '该看铺信息错误';
        }
        return $this->response($data['status'], $data['msg'], $data['data']);
    }

    public function test(){
        $agent = new Agents();
        $agent->
        $get = new GeTuiUntils();
        $title='报备提醒';

        dump($get->public_push_message_for_one(8,'hello world','测试'));die;
    }
}