<?php

namespace app\model;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2017/12/7
 * Time : 17:50
 * Intro:
 */
use think\Db;
use think\Model;
use think\Log;

class BannerModel extends Model
{
// 设置当前模型对应的完整数据表名称
    protected $table = 'u_banner';
    protected $db;
    protected $logger;

    function __construct()
    {
        $this->db = Db($this->table);
        $this->logger = new Log();
    }

    /**
     * 新增banner修改banner
     * @param $param
     * @return array
     */
    function addOrUpdate($param)
    {
        $banner = $this->db;
        $arr = array();

        if (isset($param['title'])) {
            $arr["title"] = $param['title'];
        }
        if (isset($param['cover_image'])) {
            $arr["pic_path"] = $param['cover_image'];
        }
        if (isset($param['url'])) {
            $arr["url"] = $param['url'];
        }
        if (isset($param['type'])) {
            $arr["type"] = $param['type'];
        }
        if (isset($param['sort'])) {
            $arr["sort"] = $param['sort'];
        }
        if (isset($param['is_show'])) {
            $arr["is_show"] = $param['is_show'];
        }

        $saveWhere = array();
        if (isset($param['id'])) {
            $result = $this
                ->where("id=" . $param['id'])
                ->select();
            if (count($result) > 0) {
                $saveWhere["id"] = $param["id"];
            } else {
                return [ "code" => "101", "msg" => "数据不存在" ];
            }
        } else {
            $arr["create_time"] = date("Y-m-d H:i:s", time());
            $arr["update_time"] = date("Y-m-d H:i:s", time());
        }
        //todo 暂时未做登陆页
        $arr["up_user"] = "admin";
        Db::startTrans();
        try {

            if (isset($saveWhere["id"])) {
                $id = $this->save($arr, $saveWhere);
            } else {
                //print_r($arr);exit;
                $id = $this->save($arr);
            }
            Db::commit();
            return [ "code" => "200", "msg" => $id ];
        } catch (\Exception $e) {
            Db::rollback();
            return [ "code" => "101", "msg" => "失败，数据异常" ];
        }

    }

    /**
     * 逻辑删除，不显示在前端
     * @param $param
     * @return array
     */
    function upIsShow($param)
    {
        $banner = $this->db;
        $arr = array(
            "is_show" => $param['is_show'],
            "update_time" => date("Y-m-d H:i:s", time())
        );
        Db::startTrans();
        try {
            $id = $this->save($arr, [ "id" => $param["id"] ]);
            Db::commit();
            return [ "code" => "200", "msg" => $id ];
        } catch (\Exception $e) {
            Db::rollback();
            return [ "code" => "101", "msg" => "删除失败，数据异常" ];
        }
    }

    /**
     * bannerList
     * @param int $pageNo
     * @param int $pageSize
     * @param string $order_
     * @param $field
     * @param $params
     * @return mixed
     */
    function getBannerList($pageNo = 1, $pageSize = 15, $order_ = 'id desc', $field, $params)
    {
        return $this->db
            ->field($field)
            ->where($params)
            ->order($order_)
            ->limit($pageSize)
            ->page($pageNo)
            ->select();
    }

    /**
     * 获取总记录
     * @param $params
     * @return int|string
     */
    function getBannerTotal($params)
    {
        return $this->db
            ->where($params)
            ->count();
    }
}