<?php

namespace app\api\controller;

/**
 * Created by PhpStorm.
 * User : zw
 * Date : 2017/12/6
 * Time : 15:12
 * Intro: 获取商铺list
 */
use app\common\Basic;
use app\model\HouseInfos;

class Shop extends Basic
{

    /**
     * @return \think\Response
     */
    public function getShopList()
    {
        echo define(AAA);exit;
        $params = array(
            "site_area" => 2, //来源 1首页  2搜索
            "title" => "尚美",
            "carefully_chosen" => 0,
            "yetai" => "休闲娱乐",
            "area_start" => 45,//面积起始范围 room_area2
            "area_end" => 65,//面积结束范围
            "money_start" => 1000,//租金 price2
            "money_end" => 10000,//租金
            "shangpu_tags" => "临近地铁,"
        );


        $field = "id,agent_id,title,address,city,disc,disccircles,sales,yetai,room_area2,shangpu_type,is_test,
                  room_num_left,shangpu_tags,carefully_chosen,price";

        $conditions = [];
        if (empty($params['site_area'])) {
            return $this->response("101", "请求来源不能为空");
        }

        $pageNo = empty($params['pageNo']) ? 1 : $params['pageNo'];
        $pageSize = empty($params['pageSize']) ? 15 : $params['pageSize'];

        if (isset($params['title'])) {
            $conditions['title'] = array( "like", "%" . trim($params['title']) . "%" );
        }
        $order_ = "";
        switch ($params['site_area']) {
            case 1:
                if (isset($params['carefully_chosen']) && $params['carefully_chosen'] == 0) {
                    $conditions['carefully_chosen'] = array( 'eq', $params['carefully_chosen'] );
                    $order_ = "rate1 desc";
                }
                break;
            case 2:
                if (isset($params['disc'])) { //区域
                    $conditions['disc'] = array( 'eq', trim($params['disc']) );
                }

                if (isset($params['yetai'])) { //业态
                    $conditions['yetai'] = array( 'like', "%" . trim($params['yetai']) . "%" );
                }

                //面积 room_area最小面积  room_area2最大面积 参考老版本
                if (isset($params['area_start']) && isset($params['area_end'])) {
                    $conditions['room_area'] = array( 'between', array( $params['area_start'], $params['area_end'] ) );
                    $conditions['room_area2'] = array( 'between', array( $params['area_start'], $params['area_end'] ) );
                } else if (isset($params['area_start']) && !isset($params['area_end'])) { //100米以上不用传结束面积
                    $conditions['room_area'] = array( 'egt', $params['area_start'] );
                    $conditions['room_area2'] = array( 'egt', $params['area_start'] );
                }

                if (isset($params['money_start']) && isset($params['money_end'])) { //面积
                    $conditions['price'] = array( 'between', array( $params['money_start'], $params['money_end'] ) );
                } else if (isset($params['money_start']) && !isset($params['money_end'])) { //100米以上不用传结束面积
                    $conditions['price'] = array( 'egt', $params['money_start'] );
                }

                if (isset($params['shangpu_tags'])) { //商铺标签
                    $shangpuTagsArr = array_filter(explode(',', $params['shangpu_tags']));
                    if (count($shangpuTagsArr) == 1) {
                        $conditions['shangpu_tags'] = array( 'like', "%" . trim($shangpuTagsArr[0]) . "%" );
                    } else {
                        foreach ($shangpuTagsArr as $key => $val) {
                            $conditions['shangpu_tags'][] = array( 'like', "%" . trim($val) . "%" );
                        }
                    }
                }
                $order_ = "id desc";
                break;
            default:
                $this->response("101", "请求数据异常");
        }
        if (!empty($conditions)) {
            //todo 测试数据？
            $conditions['id'] = array( '<>', 16 );
            //todo sales下架字段并没用处 根据room_num_left剩余铺数来判断 为0 表示下架
            $conditions['room_num_left'] = array( '<>', 0 );
        }

        $HouseInfos = new HouseInfos();
        $result = $HouseInfos->getHouseInfoList($pageNo, $pageSize, $order_, $field, $conditions);
        if (empty($result)) {
            return $this->response("200", "此条件没有找到数据");
        }

        return $this->response("200", '', $result);
    }
}