import re
from urllib import request
import json
import os
from aliyunsdkcore.client import AcsClient
from aliyunsdkcore.request import CommonRequest
import datetime
import time
import threading


class DownFile:
    download_num = 0
    old_num = 0
    local = threading.local()

    def __init__(self, url, save_path="./", call_date_string="call_date", page_string="page_no"):
        """
        初始化
        :param url:  下载链接
        :param save_path: 保存路径
        :param call_date_string: 日期参数
        :param page_string: 页码参数
        """
        self.url = url
        self.save_path = save_path
        self.page_string = page_string
        self.call_date_string = call_date_string
        self.lock = threading.Lock()

    @staticmethod
    def ali_yun_sdk(call_time, call_id):
        """
        获取下载链接
        :param call_time:
        :param call_id:
        :return:
        """
        client = AcsClient('LTAIEeZUju3PFZlJ', 'ljKCItiUp19F7wtzfn225WoBH0Qe8Y', 'cn-hangzhou')

        request = CommonRequest()
        request.set_accept_format('json')
        request.set_domain('dyplsapi.aliyuncs.com')
        request.set_method('POST')
        request.set_protocol_type('https')  # https | http
        request.set_version('2017-05-25')
        request.set_action_name('QueryRecordFileDownloadUrl')

        request.add_query_param('RegionId', "cn-hangzhou")
        request.add_query_param('CallId', call_id)
        request.add_query_param('PoolKey', "FC100000022056027")
        request.add_query_param('CallTime', call_time)

        response = client.do_action(request)
        json_string = str(response, encoding='utf-8')
        result = json.loads(json_string)
        if result['Code'] == "OK":
            down_url = result['DownloadUrl']
        else:
            down_url = ''
        return down_url

    @staticmethod
    def get_data(url):
        """
        获取通话记录
        :param url:
        :return:
        """
        result = request.urlopen(url)
        data = json.loads(result.read().decode("utf-8"))
        if data['code'] == 200:
            return data['data']
        else:
            return []

    def download_aliyun(self, data):
        """
        下载阿里云录音
        :param data:
        :return:
        """
        self.local.url = self.local.local_file = ""
        # self.local.count_sleep = 0
        for item in data:
            # if self.local.count_sleep >= 500:
                # self.lock.acquire()
                # self.log('sleep', '-----10s-----')
                # self.lock.release()
                # time.sleep(10)
                # self.local.count_sleep = 0

            if len(item['voice_file']) > 0:
                self.local.local_file = self.save_path + item['voice_file']
                if self.check_file(self.local.local_file):
                    # self.lock.acquire()
                    # self.old_num = self.old_num + 1
                    # self.lock.release()
                    continue

            self.local.time_array = time.strptime(item['call_time'], '%Y-%m-%d %H:%M:%S')
            self.local.local_dir = time.strftime('%Y%m%d', self.local.time_array)

            if int(item['type']) == 1:
                try:
                    self.local.count_sleep = self.local.count_sleep + 1  # 增加暂停计数
                    self.local.url = self.ali_yun_sdk(item['call_time'], item['call_id'])
                    self.local.is_ok = 0
                except Exception as result:
                    self.lock.acquire()
                    self.log("exception 20s------------", str(result))
                    self.lock.release()
                    time.sleep(20)
                    self.local.is_ok = 1

                # 第二次尝试
                if self.local.is_ok == 1:
                    try:
                        self.local.count_sleep = self.local.count_sleep + 1  # 增加暂停计数
                        self.local.url = self.ali_yun_sdk(item['call_time'], item['call_id'])
                    except Exception as result:
                        self.lock.acquire()
                        self.log(
                            "two exception error-----call_time=" + item['call_time'] + '&call_id=' + item['call_id'],
                            str(result))
                        self.lock.release()

                if len(self.local.url) == 0:
                    continue

                # 当数据库未有记录
                if item['voice_file'] == '':
                    self.local.string_end = self.local.url.find("?")
                    self.local.file_url = self.local.url[0:self.local.string_end]
                    self.local.local_file = self.save_path + self.local.local_dir + '/' + \
                                            re.findall(r".com\D.*", self.local.file_url)[0][5:]  # 阿里云文件名
                else:
                    self.local.local_file = self.save_path + '/' + item['voice_file']  # 使用已载录音文件名
            else:
                if not item['mp3_url']:
                    continue

                self.local.url = item['mp3_url']
                self.local.array = self.local.url.split('/')
                self.local.local_file = self.save_path + self.local.local_dir + '/' + self.local.array[-1]  # 容联云文件名

            if len(self.local.local_file) == 0:
                continue

            if self.check_file(self.local.local_file):
                # self.lock.acquire()
                # self.old_num = self.old_num + 1
                # self.lock.release()
                continue

            self.check_dir(self.save_path + self.local.local_dir)
            self.local.result = request.urlretrieve(self.local.url, self.local.local_file)

            # self.lock.acquire()
            # self.download_num = self.download_num + 1
            # self.log('url', self.local.url)
            # self.log('download_file', self.local.result)
            # self.log("download_num", self.download_num)
            # self.log("old_num", self.old_num)
            # self.lock.release()

    def download_remote(self, data):
        """
        下载录音服务器录音
        :param data:
        :return:
        """
        num = 0
        old_num = 0
        for item in data:
            url = "http://file.tonglianjituan.com/static/voice/" + item['voice_file']
            local_file = self.save_path + item['voice_file']
            if self.check_file(local_file):
                old_num = old_num + 1
                continue

            time_array = time.strptime(item['call_time'], '%Y-%m-%d')
            local_dir = time.strftime('%Y-%m-%d', time_array)
            self.check_dir(self.save_path + local_dir)
            result = request.urlretrieve(url, local_file)
            num = num + 1
            self.log('download_file', result)
            self.log("download_num", num)
            self.log("old_num", old_num)

    @staticmethod
    def check_file(file):
        """
        检查文件是否存在
        :param file:
        :return:
        """
        result = False
        if os.path.exists(file):
            result = True
        return result

    @staticmethod
    def check_dir(dir):
        """
        检查目录是否存在
        :param dir:
        :return:
        """
        if os.path.exists(dir):
            result = True
        else:
            os.mkdir(dir)
            result = True
        return result

    def start(self):
        """
        开始下载
        :return:
        """

        page_no = 1
        while True:
            url = self.url + "&" + self.page_string + "=" + str(page_no)
            data = self.get_data(url)
            self.log('download_page', "page_no=" + str(page_no))
            if len(data):
                self.download_aliyun(data)
            else:
                break
            page_no = page_no + 1

        self.log('download_successful', self.page_string + "=" + str(page_no))

    @staticmethod
    def log(title, content):
        """
        日志记录
        :param title:
        :param content:
        """
        time_str = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime())
        insert_string = "[{time}] {a} {b} {c}".format(time=time_str, a=title, b=content, c='\n')
        date = time.strftime("%Y-%m-%d", time.localtime())
        file_url = "./log/"
        if not os.path.exists(file_url):
            os.mkdir(file_url)
        file_url += date + ".log"
        f = open(file_url, 'a')
        f.write(insert_string)
        f.close()

    def start_thread(self, day_num=7):
        """
        开启多线程下载录音
        :param day_num: int 天数
        """
        today = datetime.date.today()
        page_no = 1
        while day_num > 0:
            one_day = datetime.timedelta(days=day_num)
            yesterday = today - one_day
            day_num = day_num - 1
            self.log('download_start', self.call_date_string + "=" + str(yesterday))

            thread = []
            while True:
                url = self.url + "&" + self.page_string + "=" + str(
                    page_no) + "&" + self.call_date_string + "=" + str(yesterday)
                data = self.get_data(url)
                self.log('download_page_th', "page_no=" + str(page_no))

                if len(data):
                    t = threading.Thread(target=self.download_aliyun, args=(data,))
                    thread.append(t)
                    t.start()
                else:
                    break
                page_no = page_no + 1

            for tt in thread:
                tt.join()

            self.log('download_successful_th', self.call_date_string + "=" + str(yesterday))

            # 重置页码
            page_no = 1
            # 跑完一天停留15秒
            time.sleep(15)

        self.log('download_over', '')


# start_url = "https://api.tonglianjituan.com/task/getDownVoiceParamsReport?source=3&call_date=2019-12-10"
# DownFile(start_url).start()
#
params_url = "https://api.tonglianjituan.com/task/getDownVoiceParamsReport?source=3"
save_path = "/data/html/tl_estate/public/static/voice/"
DownFile(params_url, save_path).start_thread(7)

params_url = "https://api.tonglianjituan.com/task/getDownVoiceParamsReport?source=3&is_user_back=1"
DownFile(params_url, save_path).start_thread(7)
# DownFile(start_url, save_path).start()
